#include "stdafx.h"
#include "test_PSM.h"
#include "ComPort.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CComPort::CComPort(CString& sComPort,CString& sBaud)
{
	m_sComPort = sComPort;
	m_sBaud = sBaud;
	m_bPortReady = FALSE;
} // end constructor CComPort

CComPort::~CComPort()
{

} // end destructor CComPort

//
// initialize the com port
//
BOOL CComPort::Initialize()
{
	DWORD	dwRC;
	DWORD	dwError;
	char	sMsg[512];

	m_bPortReady = TRUE; // everything is OK so far

	m_hCom = CreateFile(m_sComPort, 
		GENERIC_READ | GENERIC_WRITE,
		0, // exclusive access
		NULL, // no security
		OPEN_EXISTING,
		0, // no overlapped I/O
		NULL); // null template

	if (m_hCom == INVALID_HANDLE_VALUE)
	{
		m_bPortReady = FALSE;
		dwError = GetLastError();
		
		// example error code expansion follows
		LPVOID lpMsgBuf;
		lpMsgBuf = NULL;
		dwRC = FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			 NULL,
			dwError, //  from GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL);
		
		if (dwRC && lpMsgBuf)
		{
			sprintf(sMsg, "COM open failed: Port=%s Error=%d - %s",
				m_sComPort, dwError, lpMsgBuf);
			AfxMessageBox(sMsg);
		}
		else
		{
			sprintf(sMsg, "COM open failed: Port=%s Error=%d ",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
		} // end if
		if (dwRC && lpMsgBuf)
		{
			LocalFree( lpMsgBuf );
		} // end if
 
	} // end if

	if (m_bPortReady)
	{
		m_bPortReady = SetupComm(m_hCom, 
				128, 128); // set buffer sizes
		if (!m_bPortReady)
		{
			dwError = GetLastError();
			sprintf(sMsg, "SetupComm failed: Port=%s Error=%d",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
			
		} // end if
	} // end if

	if (m_bPortReady)
	{
		m_bPortReady = GetCommState(m_hCom, &m_dcb);
		if (!m_bPortReady)
		{
			dwError = GetLastError();
			sprintf(sMsg, "GetCommState failed: Port=%s Error=%d",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
		} // end if
	} // end if

	if (m_bPortReady)
	{   
		if (m_sBaud=="1200") m_dcb.BaudRate = 1200;
		else if (m_sBaud=="2400") m_dcb.BaudRate = 2400;
		else if (m_sBaud=="4800") m_dcb.BaudRate = 4800;
		else m_dcb.BaudRate = 9600;
		m_dcb.ByteSize = 8;
		m_dcb.Parity = NOPARITY;
		m_dcb.StopBits = ONESTOPBIT;
		m_dcb.fAbortOnError = TRUE;

		m_bPortReady = SetCommState(m_hCom, &m_dcb);
		if (!m_bPortReady)
		{
			dwError = GetLastError();
			sprintf(sMsg, "SetCommState failed: Port=%s Error = %d",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
		}
	} // end if

	if (m_bPortReady)
	{
		m_bPortReady = GetCommTimeouts (m_hCom, &m_CommTimeouts);
		if (!m_bPortReady)
		{
			dwError = GetLastError();
			sprintf(sMsg, "GetCommTimeouts failed: Port=%s Error = %d",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
		} // end if
	} // end if

	if (m_bPortReady)
	{
		m_CommTimeouts.ReadIntervalTimeout = 50;
		m_CommTimeouts.ReadTotalTimeoutConstant = 50;
		m_CommTimeouts.ReadTotalTimeoutMultiplier = 10;
		m_CommTimeouts.WriteTotalTimeoutConstant = 50;
		m_CommTimeouts.WriteTotalTimeoutMultiplier = 10;
		m_bPortReady = SetCommTimeouts (m_hCom, &m_CommTimeouts);
		if (!m_bPortReady)
		{
			dwError = GetLastError();
			sprintf(sMsg, "SetCommTimeouts failed: Port=%s Error = %d",
				m_sComPort, dwError);
			AfxMessageBox(sMsg);
		} // end if
	} // end if

	return m_bPortReady;
} // end CComPort::Initialize

//
// read data from the com port
//
void CComPort::Read(CString& sResult)
{
	BOOL	bReadRC;
	DWORD	iBytesRead;
	DWORD	dwError;
	char	sBuffer[128];
	char	sMsg[512];

	memset(sBuffer,0,sizeof(sBuffer));
	bReadRC = ReadFile(m_hCom, &sBuffer, 30, &iBytesRead, NULL);

	if (bReadRC && iBytesRead > 0)
	{
		sResult = sBuffer;
	}
	else
	{
		sResult = "Read Failed";
		dwError = GetLastError();
		
		sprintf(sMsg, "Read length failed: RC=%d Bytes read=%d, "
				"Error=%d ",
				bReadRC, iBytesRead, dwError);
		AfxMessageBox(sMsg);
	} // end if
} // end CComPort::Read

void CComPort::Send(CString& sTxdata)
{
	BOOL	bWriteRC;
	DWORD	iBytesWritten; 
	DWORD	dwError;
	unsigned long	n;
	char	sMsg[512];
	CString txdata=sTxdata+'\r';

	n=strlen(txdata);
	iBytesWritten = 0;
	bWriteRC = WriteFile(m_hCom, txdata,n,&iBytesWritten,NULL);
	if (!bWriteRC || iBytesWritten == 0)
	{
		dwError = GetLastError();
		
		sprintf(sMsg, "Write of length query failed: RC=%d, "
				"Bytes Written=%d, Error=%d",
				bWriteRC, iBytesWritten, dwError);
		AfxMessageBox(sMsg);		
	} // end if
}
//
// terminate the com port
//
void CComPort::Terminate()
{
	CloseHandle(m_hCom);
} // end CComPort::Terminate